% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{secret-package}
\alias{secret-package}
\alias{secret}
\title{Share Sensitive Information in R Packages.}
\description{
Allow sharing sensitive information, for example passwords, API keys,
or other information in R packages, using public key cryptography.
}
\details{
A vault is a directory, typically inside an R package, that
stores a number of secrets. Each secret is shared among a group of
users. Users are identified using their public keys.

The package implements the following operations:
\itemize{
\item Vault:
\itemize{
\item Creating a vault folder: \code{\link[=create_vault]{create_vault()}}
\item Creating a package vault: \code{\link[=create_package_vault]{create_package_vault()}}
}
\item User management:
\itemize{
\item Adding a user: \code{\link[=add_user]{add_user()}}, \code{\link[=add_github_user]{add_github_user()}}.
\item Deleting a user: \code{\link[=delete_user]{delete_user()}}.
\item Listing users: \code{\link[=list_users]{list_users()}}.
}
\item Keys:
\itemize{
\item Reading local private key: \code{\link[=local_key]{local_key()}}
}
\item Secrets:
\itemize{
\item Adding a secret: \code{\link[=add_secret]{add_secret()}}.
\item Retrieving a secret: \code{\link[=get_secret]{get_secret()}}.
\item Updating a secret: \code{\link[=update_secret]{update_secret()}}.
\item Deleting a secret: \code{\link[=delete_secret]{delete_secret()}}.
\item List secrets: \code{\link[=list_secrets]{list_secrets()}}.
\item Sharing a secret: \code{\link[=share_secret]{share_secret()}}. Query or set the set of
users that have access to a secret.
\item Unsharing a secret: \code{\link[=unshare_secret]{unshare_secret()}}
}
}
}
\author{
Gábor Csárdi and Andrie de Vries
}
\keyword{package}
