% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{add_travis_user}
\alias{add_travis_user}
\title{Add a user via their Travis repo.}
\usage{
add_travis_user(travis_repo, email, vault = NULL)
}
\arguments{
\item{travis_repo}{Name of Travis repository, usually in a format
\verb{<<username>>/<<repo>>}}

\item{email}{Email address of the user. This is used to identify
users.}

\item{vault}{Vault location (starting point to find the vault).
To create a vault, use \code{\link[=create_vault]{create_vault()}} or \code{\link[=create_package_vault]{create_package_vault()}}.
If this is \code{NULL}, then \code{secret} tries to find the vault automatically:
\itemize{
\item If the \code{secret.vault} option is set to path, that is used as the
starting point.
\item Otherwise, if the \code{R_SECRET_VAULT} environment variable is set to a
path, that is used as a starting point.
\item Otherwise the current working directory is used as the starting
point.
}

If the starting point is a vault, that is used. Otherwise, if the
starting point is in a package tree, the \code{inst/vault} folder is used
within the package. If no vault can be found, an error is thrown.}
}
\description{
On Travis, every repo has a private/public key pair. This function adds a
user and downloads the public key from Travis.
}
\examples{

\dontrun{
vault <- file.path(tempdir(), ".vault")
create_vault(vault)

add_travis_user("gaborcsardi/secret", vault = vault)
list_users(vault = vault)
delete_user("travis-gaborcsardi-secret", vault = vault)
}
}
\seealso{
Other user functions: 
\code{\link{add_github_user}()},
\code{\link{add_user}()},
\code{\link{delete_user}()},
\code{\link{list_users}()}
}
\concept{user functions}
