% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{convert_var_to_ascii}
\alias{convert_var_to_ascii}
\title{Remove non-ASCII characters from reported term in order
for Pandoc to create PDF file}
\usage{
convert_var_to_ascii(df, var)
}
\arguments{
\item{df}{dataframe}

\item{var}{variable with non-ASCII characters}
}
\value{
dataframe
}
\description{
Remove non-ASCII characters from reported term in order
for Pandoc to create PDF file
}
\examples{

df <- data.frame(
var = c("test", "teäst"),
stringsAsFactors = FALSE
)

convert_var_to_ascii(df, 'var')

df <- data.frame(
usubjid = 1:2,
var = c("test", "teästõ"),
stringsAsFactors = FALSE
)

convert_var_to_ascii(df, 'var')
}
\seealso{
Reporting-related utility functions
\code{\link{create_R_script}()},
\code{\link{truncate_var_strings}()}
}
\concept{utils_rpt}
\keyword{internal}
\keyword{utils_rpt}
