% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_qs_qsstat_qsstresc.R
\name{check_qs_qsstat_qsstresc}
\alias{check_qs_qsstat_qsstresc}
\title{Check for non-missing QSSTRESC if QSSTAT is NOT DONE}
\usage{
check_qs_qsstat_qsstresc(QS)
}
\arguments{
\item{QS}{Questionnaires SDTM dataset with variables USUBJID, QSSTRESC,
VISIT, QSSTAT, QSCAT, QSDTC, QSTESTCD}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check is for studies with PRO outcomes data (i.e., QS domain),
check that within a given instrument (e.g., QS.QSCAT='BFI' or QS.QSCAT ='MDASI"),
if QS.QSSTAT=NOT DONE and QSTESTCD=QSALL, then there should be no populated
responses(QS.QSSTRESC) for a particular visit (QS.VISIT), return a dataframe if otherwise
}
\examples{

QS <- data.frame(
STUDYID = 1,
USUBJID = c(rep(1,6),rep(2,6)),
QSSTRESC = 1:12,
VISIT = c(rep(1,3),rep(2,3),rep(1,3),rep(2,3)),
QSSTAT = rep(c("DONE","NOT DONE"),6),
QSCAT = rep(c("INDIVIDUAL","OVERALL","BFI"),4),
QSDTC = "2016-01-01",
QSTESTCD = "QSALL",
stringsAsFactors = FALSE
)

check_qs_qsstat_qsstresc(QS)

QS$QSSTRESC[4]=" "
QS$QSSTRESC[6]=NA
QS$QSSTRESC[8]="."
check_qs_qsstat_qsstresc(QS)

QS$QSSTRESC=NULL
check_qs_qsstat_qsstresc(QS)

}
\author{
Sara Bodach
}
