% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_cm_cmdecod.R
\name{check_cm_cmdecod}
\alias{check_cm_cmdecod}
\title{Check for missing CMDECOD values}
\usage{
check_cm_cmdecod(CM, preproc = identity, ...)
}
\arguments{
\item{CM}{Concomitant Medications SDTM dataset with variables USUBJID, CMTRT, CMDECOD}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
This check looks for missing CMDECOD values
}
\examples{

CM <- data.frame(
 USUBJID = 1:5,
 DOMAIN = rep("CM", 5),
 CMTRT = rep("DRUG TERM", 5),
 CMDECOD = rep("CODED DRUG TERM", 5),
 CMSTDTC = 1:5,
 CMENDTC = 1:5,
 CMCAT = "CONCOMITANT MEDICATIONS",
 CMSPID = c("FORMNAME-R:13/L:13XXXX",
             "FORMNAME-R:16/L:16XXXX",
             "FORMNAME-R:2/L:2XXXX",
             "FORMNAME-R:19/L:19XXXX",
             "FORMNAME-R:5/L:5XXXX"),
 stringsAsFactors=FALSE
)

check_cm_cmdecod(CM)

CM$CMDECOD[1] = NA
CM$CMDECOD[2] = "NA"
CM$CMDECOD[3:5] = ""
check_cm_cmdecod(CM)
check_cm_cmdecod(CM,preproc=roche_derive_rave_row)

CM$CMDECOD <- NULL
check_cm_cmdecod(CM)

}
\author{
Lei Zhao, Stella Banjo (HackR 2021)
}
