% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to-code-list.R
\name{match_code_list_from_term}
\alias{match_code_list_from_term}
\alias{match_code_list_from_code}
\title{Match code lists}
\usage{
match_code_list_from_term(term)

match_code_list_from_code(code)
}
\arguments{
\item{term}{A character vector of SDTM terminology terms.}

\item{code}{A character vector of SDTM terminology C-codes.}
}
\value{
A \link[tibble:tibble-package]{tibble} with at least as many rows as
there are elements in \code{term}, but potentially more because of one-to-many
mappings. The returned tibble comprises three columns:
\describe{
\item{\code{code}}{An SDTM terminology code (e.g. \code{"C141701"}).}
\item{\code{term}}{An SDTM terminology term (e.g. \code{"TENMW104"}).}
\item{\code{clst_code}}{The code of the associated code list.}
}
}
\description{
\code{\link[=match_code_list_from_term]{match_code_list_from_term()}} takes terms as queries to look for associated
code lists.

\code{\link[=match_code_list_from_code]{match_code_list_from_code()}} does the same starting from
C-codes.

Note that both mappings are potentially one to many as the same code
or term may associate with more than one code list.
}
\examples{
# Find code lists where "DNA" and "RNA" are used.
match_code_list_from_term(c("DNA", "RNA"))

# Find code lists where "Yes"/"No" terms are controlled vocabulary.
match_code_list_from_term(c("Yes", "No"))

# C163560 is found in code list C71620.
match_code_list_from_code("C163560")

# C25613 however is mapped to many code lists.
match_code_list_from_code("C25613")

# Unmappable codes or terms map to `NA`.
match_code_list_from_code("Yoda")
match_code_list_from_term("R2D2")

# Codes for code lists are for all intents and purposes not mappable to
# parent code lists.
match_code_list_from_code(code = "C141657")

}
