% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode.R
\name{index_for_recode}
\alias{index_for_recode}
\title{Determine Indices for Recoding}
\usage{
index_for_recode(x, from)
}
\arguments{
\item{x}{A vector of values in which to search for matches.}

\item{from}{A vector of values to match against the elements in \code{x}.}
}
\value{
An integer vector of the same length as \code{x}, containing the indices
of the matched values from the \code{from} vector. If an element in \code{x} does not
match any value in \code{from}, the corresponding position in the output will be
\code{NA}. This index information is critical for subsequent recoding operations.
}
\description{
\code{\link[=index_for_recode]{index_for_recode()}} identifies the positions of elements in \code{x} that match
any of the values specified in the \code{from} vector. This function is primarily
used to facilitate the recoding of values by pinpointing which elements in
\code{x} correspond to the \code{from} values and thus need to be replaced or updated.
}
\keyword{internal}
