% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_norm.R
\name{scores_norm}
\alias{scores_norm}
\alias{crps_norm}
\alias{crps_cnorm}
\alias{crps_tnorm}
\alias{crps_gtcnorm}
\alias{logs_norm}
\alias{logs_tnorm}
\alias{dss_norm}
\alias{gradcrps_norm}
\alias{gradcrps_cnorm}
\alias{gradcrps_tnorm}
\alias{hesscrps_norm}
\alias{hesscrps_cnorm}
\alias{hesscrps_tnorm}
\title{Calculating scores for the normal distribution}
\usage{
## score functions
crps_norm(y, mean = 0, sd = 1, location = mean, scale = sd)
crps_cnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
crps_tnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
crps_gtcnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf, lmass = 0, umass = 0)
logs_norm(y, mean = 0, sd = 1, location = mean, scale = sd)
logs_tnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
dss_norm(y, mean = 0, sd = 1, location = mean, scale = sd)

## gradient (location, scale) functions
gradcrps_norm(y, location = 0, scale = 1)
gradcrps_cnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
gradcrps_tnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf)

## Hessian (location, scale) functions
hesscrps_norm(y, location = 0, scale = 1)
hesscrps_cnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
hesscrps_tnorm(y, location = 0, scale = 1, lower = -Inf, upper = Inf)
}
\arguments{
\item{y}{vector of observations.}

\item{mean}{an alternative way to specify \code{location}.}

\item{sd}{an alternative way to specify \code{scale}.}

\item{location}{vector of location parameters.}

\item{scale}{vector of scale parameters.}

\item{lower, upper}{lower and upper truncation/censoring bounds.}

\item{lmass, umass}{vectors of point masses in \code{lower} and \code{upper}
respectively.}
}
\value{
For the score functions: a vector of score values.

For the gradient and Hessian functions: a matrix with column names
corresponding to the respective partial derivatives.
}
\description{
These functions calculate scores (CRPS, LogS, DSS) and
their gradient and Hessian with respect
to the parameters of a location-scale transformed normal
distribution. Furthermore, the censoring transformation and
the truncation transformation may be introduced on top of the
location-scale transformed normal distribution.
}
\examples{
\dontrun{
# Illustrations: Compare CRPS of analytical distribution to 
# CRPS of a large sample drawn from this distribution 
# (expect scores to be similar)

# First illustration: Standard normal 
# Consider CRPS at arbitrary evaluation point (value of outcome)
y <- 0.3
crps_norm(y = y) # score of analytical dist.
# draw standard normal sample of size 10000
dat <- rnorm(1e4)
crps_sample(y = y, dat = dat) # score of sample

# Second illustration: Truncated standard normal
# truncation point
upper <- 1
crps_tnorm(y = y, upper = upper) # score of analytical dist.
# sample from truncated normal 
dat_trunc <- dat[dat <= upper] 
crps_sample(y = y, dat = dat_trunc) # score of sample

# Third illustration: Censored standard normal (censoring at \code{upper})
crps_cnorm(y = y, upper = upper) # score of analytical dist.
# sample from censored normal 
dat_cens <- ifelse(dat <= upper, dat, upper)
crps_sample(y = y, dat = dat_cens) # score of sample
}
}
