% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_localmaxima.R
\name{detect_localmaxima}
\alias{detect_localmaxima}
\title{detect local maxima in univariate time series data}
\usage{
detect_localmaxima(data, w = 3, boundary = "reflecting")
}
\arguments{
\item{data}{a numeric vector. Length of data must be greater than 1.}

\item{w}{window size. w must be odd and greater than 2 and smaller than double length of data.}

\item{boundary}{determines how data points in the beginning and end of the time series will be treated. "reflecting", "r": reflecting boundary condition, "periodic", "p": periodic boundary condition, "discard", "d", discarding data points in the beginning and end of the time series. See the vignette "Introduction to scorepeak" for detail.}
}
\value{
a logical vector. TRUE indicates local peak. FALSE indicates not local peak.
}
\description{
detect local maxima in univariate time series data
}
\examples{
data("ecgca102")
peaks <- detect_localmaxima(ecgca102)
plot(ecgca102, type = "l")
points(which(peaks), ecgca102[peaks], pch = 1, col = "red")
}
\author{
Shota Ochi
}
