% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dtree_trend_iv}
\alias{dtree_trend_iv}
\title{Recursive Decision Tree partitioning with monotonic event rate along with IV table for individual numerical variable}
\usage{
dtree_trend_iv(base, target, variable, num_missing = -99999,
  mincriterion = 0.1, event = 1)
}
\arguments{
\item{base}{input dataframe}

\item{target}{column / field name for the target variable to be passed as string (must be 0/1 type)}

\item{variable}{numerical variable name which is to be binned into categorical buckets, to be passed as string}

\item{num_missing}{(optional) imputed missing value for numerical variable or an array of values which are to be kept as different bucket in binning step (default value is -99999)}

\item{mincriterion}{(optional) the value of the test statistic or (1 - p-value) that must be exceeded in order to implement a split (default value is 0.1)}

\item{event}{(optional) the event class, to be passed as 0 or 1 (default is 1)}
}
\value{
The function returns a dataframe with count and iv.
}
\description{
The function takes base data, target and the numerical variable which is to be binned. It returns the optimal cuts based on recursive partitioning decision tree such that the trend of event rate holds good ie. it is strictly monotonically increasing or decreasing. If missing values are imputed by any extreme value, the same can be passed as an argument, and it will be shown as a different category. The output is a dataframe with the WOE and IV value.
}
\examples{
data <- iris
data$Y <- ifelse(data$Species=="setosa",1,0)
dtree_trend_tab <- dtree_trend_iv(base = data,target = "Y",variable = "Sepal.Length",event = 1)
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>

Aiana Goyal <aianagoel002@gmail.com>
}
