% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_download.R
\name{scf_download}
\alias{scf_download}
\title{Download and Prepare SCF Microdata for Local Analysis}
\usage{
scf_download(years = seq(1989, 2022, 3), overwrite = FALSE, verbose = TRUE)
}
\arguments{
\item{years}{Integer vector of SCF years to download (e.g., \code{c(2016, 2019)}). Must be triennial from 1989 to 2022.}

\item{overwrite}{Logical. If \code{TRUE}, re-download and overwrite existing \code{.rds} files. Default is \code{FALSE}.}

\item{verbose}{Logical. If \code{TRUE}, display progress messages. Default is \code{TRUE}.}
}
\value{
These files are designed to be loaded using scf_load(), which wraps them into replicate-weighted designs.
}
\description{
Downloads SCF public-use microdata from official servers.  For each year,
this function retrieves five implicates, merges them with replicate weights
and official summary variables, and saves them as \code{.rds} files ready for use
with \code{\link[=scf_load]{scf_load()}}.
}
\section{Implementation}{

This function downloads from official servers three types of files for each
year:
\itemize{
\item five versions of the dataset (one per implicate), each stored as a separate data frame in a list
\item a table of replicate weights, and
\item a data table with official derivative variables
}

These tables are collected to a list and saved to an \code{.rds} format file in
the working directory.  By default, the function downloads all available
years.
}

\section{Details}{

The SCF employs multiply-imputed data sets to address unit-level missing
data. Each household appears in one of five implicates. This function ensures
all implicates are downloaded, merged, and prepared for downstream analysis
using \code{\link[=scf_load]{scf_load()}}, \code{\link[=scf_design]{scf_design()}}, and the \code{scf} workflow.
}

\examples{
if (FALSE) {
  # Download and prepare SCF data for 2022
  td <- tempfile("download_")
  dir.create(td)

  old <- getwd()
  setwd(td)
  scf_download(2022)

  # Load into a survey design object
  scf2022 <- scf_load(2022, data_directory = td)

  # Cleanup for package check
  unlink(td, recursive = TRUE, force = TRUE)
  setwd(old)
}

}
\references{
U.S. Federal Reserve. Codebook for 2022 Survey of Consumer Finances.
https://www.federalreserve.gov/econres/scfindex.htm
}
\seealso{
\code{\link[=scf_load]{scf_load()}}, \code{\link[=scf_design]{scf_design()}}, \code{\link[=scf_update]{scf_update()}}
}
