% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{segment.count_open}
\alias{segment.count_open}
\title{Extract number of open dwells. In the case of subconductive states,
count the number of non-zero states.}
\usage{
segment.count_open(segment)
}
\arguments{
\item{segment}{the segment object}
}
\value{
number of open dwells
}
\description{
Extract number of open dwells. In the case of subconductive states,
count the number of non-zero states.
}
\examples{

# It's more likely that you created states or dwells with some function
states  <-  c(0,      1,    0,    1,    0,    1,    0,    1,    0,    1)
dwells  <-  c(0.1,  1.1,  0.5,  0.2,  1.0,  1.1,  0.6,  1.1,  0.8,  1.1)
my_burst <- segment.create(states, dwells, seg=1, start_time=3.14159, name="example_segment")

segment.count_open(my_burst)

}
