% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlotMatrix.R
\name{getPlotConfig}
\alias{getPlotConfig}
\title{Retrieve plot configuration}
\usage{
getPlotConfig(id, configInputId)
}
\arguments{
\item{id}{Output variable to read from (id which references the requested plot).}

\item{configInputId}{Reactive input to write to.}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Result will be sent through a reactive input (see example below).
}
\examples{
\dontrun{
   library(shiny)
   library(shinyjs)
   library(scatterPlotMatrix)

   ui <- fluidPage(
     useShinyjs(),
     p("Button saves the widget as an html file, reproducing its configuration"),
     actionButton("downloadButton", "Download Widget"),
     downloadButton("associatedDownloadButton", "Download Widget",
       style = "visibility: hidden;"
     ),
     scatterPlotMatrixOutput("spMatrix", height = 960)
   )

   server <- function(input, output, session) {
     output$spMatrix <- renderScatterPlotMatrix({
       scatterPlotMatrix(iris)
     })
     observeEvent(input$downloadButton, {
       scatterPlotMatrix::getPlotConfig("spMatrix", "ConfigForDownload")
     })
     observeEvent(input$ConfigForDownload, {
       spmForDownload <<- scatterPlotMatrix(
         data = iris,
         categorical = input$ConfigForDownload$categorical,
         inputColumns = input$ConfigForDownload$inputColumns,
         cutoffs = input$ConfigForDownload$cutoffs,
         keptColumns = input$ConfigForDownload$keptColumns,
         zAxisDim = input$ConfigForDownload$zAxisDim,
         distribType = as.numeric(input$ConfigForDownload$distribType),
         regressionType = as.numeric(input$ConfigForDownload$regressionType),
         corrPlotType = input$ConfigForDownload$corrPlotType,
         corrPlotCS = input$ConfigForDownload$corrPlotCS,
         rotateTitle = input$ConfigForDownload$rotateTitle,
         columnLabels = input$ConfigForDownload$columnLabels,
         continuousCS = input$ConfigForDownload$continuousCS,
         categoricalCS = input$ConfigForDownload$categoricalCS,
         mouseMode = input$ConfigForDownload$mouseMode,
         controlWidgets = NULL,
         cssRules = input$ConfigForDownload$cssRules,
         plotProperties = input$ConfigForDownload$plotProperties,
         slidersPosition = input$ConfigForDownload$slidersPosition
       )
       shinyjs::runjs("document.getElementById('associatedDownloadButton').click();")
     })
     output$associatedDownloadButton <- downloadHandler(
       filename = function() {
         paste("scatterPlotMatrix-", Sys.Date(), ".html", sep = "")
       },
       content = function(tmpContentFile) {
         htmlwidgets::saveWidget(spmForDownload, tmpContentFile)
       }
     )
   }

   shinyApp(ui, server)
 }

}
