% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotMatchedOntoTree}
\alias{plotMatchedOntoTree}
\title{Plot a ontology tree with matched ontology from ontoMatch}
\usage{
plotMatchedOntoTree(
  obj_list,
  ont,
  anno_col = "cell_ontology_mapped",
  onto_id_col,
  roots = c("CL:0000548"),
  ...
)
}
\arguments{
\item{obj_list}{a list of seurat obj files as the output of ontoMatch}

\item{ont}{ontology object}

\item{anno_col}{the cell ontology text annotation column name}

\item{onto_id_col}{if also have ontology id column for direct mapping}

\item{roots}{root ontology in tree to plot, default "animal cells" in cell ontology}

\item{...}{additional parameters for ontologyPlot::onto_plot}
}
\value{
a lit of matched ontology tree plot
}
\description{
Plot a ontology tree with matched ontology from ontoMatch
}
\examples{
\dontrun{
plotMatchedOntoTree(seurat_obj_list, ont, 'cell_ontology_mapped', 'ontology_id')
}
}
