% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{sc_cols_bounded_above}
\alias{sc_cols_bounded_above}
\title{Checks that all elements from the given columns are below a certain number}
\usage{
sc_cols_bounded_above(
  object,
  cols,
  upper_bound,
  include_upper_bound = TRUE,
  ...
)
}
\arguments{
\item{object}{table with a columns specified by \code{cols}}

\item{cols}{vector of characters of columns that are checked against
the specified range}

\item{upper_bound}{elements of the specified columns must be below this
bound}

\item{include_upper_bound}{if TRUE (default), elements are allowed to be
equal to the \code{upper_bound}}

\item{...}{further parameters that are passed to \link{add_sanity_check}.}
}
\value{
list of logical vectors where TRUE indicates where the check failed.
  Every list entry represents one of the columns specified in cols.
  This might be helpful if one wants to apply a counter-measure
}
\description{
Checks that all elements from the given columns are below a certain number
}
