% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{spicer2022.anchoringrepulsion.e2a}
\alias{spicer2022.anchoringrepulsion.e2a}
\title{Data from Experiment 2a in \insertCite{spicer2022PerceptualCognitiveJudgments;textual}{samplrData}}
\format{
An object of class \code{data.frame} with 9920 rows and 13 columns.
}
\source{
\url{https://osf.io/95ruy/}
}
\usage{
spicer2022.anchoringrepulsion.e2a
}
\description{
Cognitive judgments. Participants answered questions about commonly experienced values. Unlike in Experiment 2, participants viewed each question multiple times, comparing each against both a low (25.5) and high (75.5) comparison value to create 40 trial cases. As in Experiment 1, decisions were requested on all trials, but only 30\% of trials were randomly selected to include a direct estimate.
}
\details{
This experiment is described in the supplementary materials.
These data are licensed under \href{https://creativecommons.org/licenses/by/4.0/}{CC BY 4.0}, reproduced from materials in \href{https://osf.io/95ruy/}{OSF}.
\describe{
\item{Timestamp}{Date and time of the experimental session}
\item{Pt}{Unique ID for that participant}
\item{Trial}{Trial ID based on order of presentation}
\item{QID}{ID for the target question of that trial. Note that these IDs match those of the calibration data.}
\item{Question}{Question text for that trial}
\item{Region}{Expected region for that question, being either high or low}
\item{Answer}{Unbiased answer for that question from calibration data}
\item{Boundary}{Comparison value for that trial}
\item{Decision}{Decision made by the participant on whether answer to the question was higher or lower than the boundary for that trial}
\item{Dec_RT}{Response time for the decision}
\item{Accuracy}{Accuracy of the selected decision based on calibration data}
\item{Estimate}{Direct estimate of the answer to the question for that trial made by the participant. NaN is used for trials in which no estimate was requested}
\item{Est_RT}{Response time for the estimate}
}
}
\references{
\insertRef{spicer2022PerceptualCognitiveJudgments}{samplrData}
}
\keyword{datasets}
