% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correl.R
\name{correl}
\alias{correl}
\title{Sample Size for Testing Correlation Coefficient}
\usage{
correl(rho0, rho1, alp, pwr)
}
\arguments{
\item{rho0}{magnitude of relationship between the two variables under study, set at null hypothesis}

\item{rho1}{anticipated magnitude of relationship between the two variables under study}

\item{alp}{level of significance or accepted level of probability of type I error}

\item{pwr}{desired level of power}
}
\value{
a list object with minimum required sample size along with description for reporting
}
\description{
Calculates minimum sample size needed to detect at
least rho0-rho1 units difference in the hypothesized and reported correlation
coefficient for desired level of significance and power
}
\examples{
correl(rho0 = 0.5, rho1 = 0.7, alp = 0.05, pwr = 0.8)
}
\references{
Bujang, M. A., & Baharum, N. (2016). Sample size guideline for correlation analysis. World Journal of Social Science, 3(1), 37-46.
}
\author{
R. Amala, Scientist-C, ICMR-VCRC, Puducherry  & G. Kumarapandiyan, Asst. Prof., Madras Christian College, Chennai
}
