% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e4ddp.R
\name{e4ddp}
\alias{e4ddp}
\title{Statistical errors for the estimation of a double difference of proportions}
\usage{
e4ddp(N, n, P1, P2, P3, P4, DEFF = 1, conf = 0.95, plot = FALSE)
}
\arguments{
\item{N}{The population size.}

\item{n}{The sample size.}

\item{P1}{The value of the first estimated proportion.}

\item{P2}{The value of the second estimated proportion.}

\item{P3}{The value of the third estimated proportion.}

\item{P4}{The value of the fouth estimated proportion.}

\item{DEFF}{The design effect of the sample design. By default \code{DEFF = 1}, which corresponds to a simple random sampling design.}

\item{conf}{The statistical confidence. By default \code{conf = 0.95}.}

\item{plot}{Optionally plot the errors (cve and margin of error) against the sample size.}
}
\value{
The coefficient of variation and the margin of error for a predefined sample size.
}
\description{
This function computes the cofficient of variation and the standard error when estimating a double difference of proportions under a complex sample design.
}
\details{
We note that the margin of error is defined as: \deqn{cve = \frac{\sqrt{Var((\hat{P}_1 - \hat{P}_2) - (\hat{P}_3 - \hat{P}_4) ) }}{(\hat{P}_1 - \hat{P}_2) - (\hat{P}_3 - \hat{P}_4)}} 
Also, note that the magin of error is defined as: \deqn{\varepsilon = z_{1-\frac{\alpha}{2}}\sqrt{Var((\hat{P}_1 - \hat{P}_2) - (\hat{P}_3 - \hat{P}_4) )}}
}
\examples{
e4ddp(N=10000, n=400, P1=0.5, P2=0.6, P3=0.5, P4=0.7)
e4ddp(N=10000, n=400, P1=0.5, P2=0.6, P3=0.5, P4=0.7, plot=TRUE)
e4ddp(N=10000, n=400, P1=0.5, P2=0.6, P3=0.5, P4=0.7, DEFF=3.45, conf=0.99, plot=TRUE)
}
\references{
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{ss4p}}
}
\author{
Hugo Andres Gutierrez Rojas <hagutierrezro at gmail.com>
}
