% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_bias.R
\name{map_bias}
\alias{map_bias}
\title{Mapping Projected Bias Effects}
\usage{
map_bias(x, gaz = NULL, sealine = TRUE, type = "sampling_rate")
}
\arguments{
\item{x}{a raster stack as generate by \code{\link{project_bias}}}

\item{gaz}{a list of SpatialObjects, to be printed on the maps.  Should be
the same objects provided to \code{calculate_bias} when creating the Object.
If \code{gaz} is not supplied, the sampbias package standard gazetteers are
used.}

\item{sealine}{logical. Should the coastline be added to the plots? Default is
to TRUE.}

\item{type}{character vector. One of c("sampling_rate", "log_sampling_rate", "diff_to_max"). If "sampling_rate".
the plot shows the raw projected sampling rate depending on the
biasing factors, if "log_sampling_rate", the plot shows the log10 transformed sampling rate, and if
"diff_to_max", the relative deviation of sampling rate from the maximum
rate as calculated using \code{\link{calculate_bias}}
and projected using \code{\link{project_bias}}. For instance, a value of -25 indicates
a drop of 25% compared to the highest rate
(e.g. in a road on river flowing through the city airport).}
}
\value{
A series of R plots based on ggplot2.
}
\description{
A plotting function to visualize the effect of accessibility bias caused by different biasing factors
in space.
}
\examples{
\donttest{
  #simulate data
  occ <- data.frame(species = rep(sample(x = LETTERS, size = 5), times = 10),
                   decimalLongitude = runif(n = 50, min = 12, max = 20),
                   decimalLatitude = runif(n = 50, min = -4, max = 4))

  out <- calculate_bias(x = occ, terrestrial = TRUE)
  proj <- project_bias(out)
  map_bias(proj)
}

}
\seealso{
\code{\link{calculate_bias}}, \code{\link{project_bias}}
}
\keyword{methods}
