% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe2x2Test.R
\name{computeConfidenceBoundForLogOddsTwoProportions}
\alias{computeConfidenceBoundForLogOddsTwoProportions}
\title{Estimate an upper or lower bound for a safe confidence sequence on the
logarithm of the odds ratio for two proportions.}
\usage{
computeConfidenceBoundForLogOddsTwoProportions(
  ya,
  yb,
  safeDesign,
  bound = c("lower", "upper"),
  deltaStart,
  deltaStop,
  precision
)
}
\arguments{
\item{ya}{positive observations/ events per data block in group a: a numeric with integer values
between (and including) 0 and \code{na}, the number of observations in group a per block.}

\item{yb}{positive observations/ events per data block in group b: a numeric with integer values
between (and including) 0 and \code{nb}, the number of observations in group b per block.}

\item{safeDesign}{a 'safeDesign' object obtained through
\code{\link{designSafeTwoProportions}}}

\item{bound}{type of bound to calculate; "lower" to get a lower bound on positive delta,
"upper" to get an upper bound on negative delta.}

\item{deltaStart}{starting value of the grid to search over for the bound on the confidence
sequence (in practice: the interval). Numeric >0 when searching for a lower bound, numeric < 0
when searching for an upper bound.}

\item{deltaStop}{end value of the grid to search over for the bound on the confidence
sequence (in practice: the interval). Numeric >0 when searching for a lower bound, numeric < 0
when searching for an upper bound.}

\item{precision}{precision of the grid between deltaStart and deltaStop.}
}
\value{
numeric: the established lower- or upper bound on the logarithm of the odds
ratio between the groups
}
\description{
Estimate an upper or lower bound for a safe confidence sequence on the
logarithm of the odds ratio for two proportions.
}
\examples{
balancedSafeDesign <- designSafeTwoProportions(na = 1,
                                               nb = 1,
                                               nBlocksPlan = 10,
                                               alpha = 0.05)
#hypothesize OR < 1 (i.e., log OR < 0)
ya <- c(1,1,1,1,1,1,1,1,0,1)
yb <- c(0,0,0,0,1,0,0,0,0,0)
#one-sided CI for OR-, establish upper bound on log odds ratio
computeConfidenceBoundForLogOddsTwoProportions(ya = ya,
                                           yb = yb,
                                           safeDesign = balancedSafeDesign,
                                           bound = "upper",
                                           deltaStart = -0.01,
                                           deltaStop = -4,
                                           precision = 20)

}
