% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{checkAndReturnsNPlan}
\alias{checkAndReturnsNPlan}
\title{Check consistency between nPlan and the testType for one and two-sample z and t-tests}
\usage{
checkAndReturnsNPlan(
  nPlan,
  ratio = 1,
  testType = c("oneSample", "paired", "twoSample")
)
}
\arguments{
\item{nPlan}{optional numeric vector of length at most 2. When provided, it is used to find the safe test
defining parameter phiS. Note that if the purpose is to plan based on nPlan alone, then both meanDiffMin
and beta should be set to NULL.}

\item{ratio}{numeric > 0 representing the randomisation ratio of condition 2 over condition 1. If testType
is not equal to "twoSample", or if nPlan is of length(1) then ratio=1.}

\item{testType}{either one of "oneSample", "paired", "twoSample".}
}
\value{
nPlan a vector of sample sizes of length 1 or 2
}
\description{
Check consistency between nPlan and the testType for one and two-sample z and t-tests
}
