% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_types.R
\name{validate_types}
\alias{validate_types}
\title{Type check variables}
\usage{
validate_types(x, ...)
}
\arguments{
\item{x}{a \code{safeframe} object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> A named list with tags in \code{x}
as list names and the related types as list values.}
}
\value{
A named \code{list}.
}
\description{
This function checks the type of variables in a \code{safeframe} against
accepted classes. Only checks the type of provided variables and ignores
those not provided.
}
\examples{
x <- make_safeframe(cars,
  mph = "speed",
  distance = "dist"
)
x

## the below would issue an error
## note: tryCatch is only used to avoid a genuine error in the example
tryCatch(validate_types(x), error = paste)

## to allow other types, e.g. gender to be integer, character or factor
validate_types(x, mph = "numeric", distance = c(
  "integer",
  "character", "numeric"
))

}
\seealso{
\itemize{
\item \code{\link[=validate_tags]{validate_tags()}} to perform a series of checks on variables
\item \code{\link[=validate_safeframe]{validate_safeframe()}} to combine \code{validate_tags} and \code{validate_types}
}
}
