% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_tags.R
\name{validate_tags}
\alias{validate_tags}
\title{Checks the tags of a safeframe object}
\usage{
validate_tags(x)
}
\arguments{
\item{x}{a \code{safeframe} object}
}
\value{
If checks pass, a \code{safeframe} object; otherwise issues an error.
}
\description{
This function evaluates the validity of the tags of a \code{safeframe} object by
checking that: i) tags are present ii) tags is a \code{list} of \code{character} or
\code{NULL} values.
}
\examples{
## create a valid safeframe
x <- cars |>
  make_safeframe(
    mph = "speed",
    distance = "dist"
  )
x

## the below issues an error as safeframe doesn't know any defaults
## note: tryCatch is only used to avoid a genuine error in the example
tryCatch(validate_safeframe(x), error = paste)

## validation requires you to specify the types directly
validate_safeframe(x,
  mph = c("integer", "numeric"),
  distance = "numeric"
)
}
\seealso{
\code{\link[=validate_types]{validate_types()}} to check if tagged variables have
the right classes
}
