% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saeczi.R
\name{saeczi}
\alias{saeczi}
\title{Fit a zero-inflation estimator.}
\usage{
saeczi(
  samp_dat,
  pop_dat,
  lin_formula,
  log_formula = lin_formula,
  domain_level,
  B = 100L,
  mse_est = FALSE,
  estimand = "means",
  parallel = FALSE
)
}
\arguments{
\item{samp_dat}{A data.frame with domains, auxiliary variables, and the response variable of a sample}

\item{pop_dat}{A data.frame with domains and auxiliary variables of a population.}

\item{lin_formula}{Formula. Specification of the response and fixed effects of the linear regression model}

\item{log_formula}{Formula. Specification of the response and fixed effects of the logistic regression model}

\item{domain_level}{String. The column name in samp_dat and pop_dat that encodes the domain level}

\item{B}{Integer. The number of bootstraps to be used in MSE estimation.}

\item{mse_est}{Logical. Whether or not MSE estimation should happen.}

\item{estimand}{String. Whether the estimates should be 'totals' or 'means'.}

\item{parallel}{Logical. Should the MSE estimation be computed in parallel}
}
\value{
An object of class `zi_mod` with defined `print()` and `summary()` methods.
The object is structured like a list and contains the following elements:

* call: The original function call

* res: A data.frame containing the estimates and mse estimates

* lin_mod: The modeling object used to fit the original linear model

* log_mod: The modeling object used to fit the original logistic model
}
\description{
Fit a zero-inflation estimator.
}
\examples{
data(pop)
data(samp)

lin_formula <- DRYBIO_AG_TPA_live_ADJ ~ tcc16 + elev

result <- saeczi(samp_dat = samp,
                 pop_dat = pop,
                 lin_formula = lin_formula,
                 log_formula = lin_formula,
                 domain_level = "COUNTYFIPS",
                 mse_est = FALSE)

}
