% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vectorRao.R
\name{vectorRao}
\alias{vectorRao}
\title{Vector g in Newton Raphson Method by J.N.K.Rao}
\usage{
vectorRao(alpha, beta, ni, yi)
}
\arguments{
\item{alpha}{An alpha estimate value on iterating process}

\item{beta}{A beta estimate value on iterating process}

\item{ni}{The number of sample in each area}

\item{yi}{The number of "success" value in each area}
}
\value{
This function returns a value of vector g.
}
\description{
Vector g in Newton Raphson Method by J.N.K.Rao
}
\examples{
## load dataset with no weight value
data(dataEB)
temp = pcapdir(dataEB[,-c(3)])

## estimates alpha and beta parameter
## in EB estimate with Moment method by J.N.K.Rao
temp1 = alphabetaEB(data.dir = temp$direst ,pcap = temp$pcap,
                      method = "rao", opt = "moment",
                      maxiter = 100,tol = 0.00001)

##calculates vector g
vectorRao(alpha = temp1$alpha_cap, beta = temp1$beta_cap,
 ni = temp$direst$ni, yi = temp$direst$yi)

}
