% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sadverif.R
\name{sadverif}
\alias{sadverif}
\alias{plot.sadverif}
\alias{summary.sadverif}
\title{dual-tree verification}
\usage{
sadverif(x, dec = TRUE, xmin = 0.1, log = TRUE, a = 1, nbr = 33,
  rsm = 0, Nx = NULL, Ny = NULL, J = NULL, boundaries = "pad",
  return_specs = FALSE)

\method{plot}{sadverif}(x, ...)

\method{summary}{sadverif}(object, ...)
}
\arguments{
\item{x}{a list of equally sized matrices, the first element is assumed to be the observation}

\item{dec}{logical, do you want to use the decimated transform}

\item{xmin}{values smaller than \code{xmin} are set to zero}

\item{log}{logical, do you want to log-transfrom the data? (recommended for precipitation)}

\item{a}{relative weight of directional errors compared to scale errors in \code{semdd}}

\item{nbr}{number of breaks for the scale histograms, has no effect if \code{dec=TRUE}}

\item{rsm}{number of pixels which are linearly smoothed at the edge}

\item{Nx}{size to which the data is extended in x-direction}

\item{Ny}{size to which the data is extended in y-direction}

\item{J}{largest scale considered}

\item{boundaries}{how to handle the boundary conditions, either "pad", "mirror" or "periodic"}

\item{return_specs}{if \code{TRUE}, the spatial mean spectra are returned as well}

\item{...}{further arguments, currently ignored.}

\item{object}{object of class sadverif}
}
\value{
an object of class \code{sadverif}, containing the following elements
\describe{
   \item{settings}{ a dataframe containing the parameters that were originally passed to dtverif }
   \item{centres}{ a matrix cotaining the anisotropy \code{rho}, angle \code{phi} and central scale \code{z} derived from the mean spectra. Rain area and sum are included as well.}
   \item{detscores}{ a matrix containing the differences in centre components, the direction/anisotropy score \code{dxy}, the emd between direction-averaged spectra (\code{semd}) and the emd between the directional spectra (\code{semdd}). If \code{dec=FALSE}, the emd between the scale histograms, hemd, is included as well. }
   \item{time}{ the time the calculation took in seconds }
}
if there is more than one forecast, the ensemble scores SpEn and (if available), hemd are computed as well, treating all forecasts as members of the ensemble to be verified.
}
\description{
verify the scale, anisotropy and direction of a number of forecasts
}
\details{
each element of x is transformed via \code{dtcwt} from the 'dualtrees' package. Scores and centres based on the mean spectra are calculated. If \code{dec=FALSE}, scale histograms and the corresponding score \code{hemd} are calcualted as well.
}
\examples{
oldpar <- par(no.readonly=TRUE)
on.exit(par(oldpar))
data(rrain)
ra <- as.sadforecast( list( rrain[1,1,,], rrain[1,2,,], rrain[2,1,,], rrain[3,1,,] ) )
plot(ra)
verif <- sadverif( ra, log=FALSE, xmin=0 )
summary(verif)
par( mfrow=c(2,2) )
plot( verif )
}
\references{
Selesnick, I.W., R.G. Baraniuk, and N.C. Kingsbury (2005) <doi:10.1109/MSP.2005.1550194>
Buschow et al. (2019) <doi:10.5194/gmd-12-3401-2019>
Buschow and Friederichs (2020) <doi:10.5194/ascmo-6-13-2020>
}
