% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lowlevel.R
\name{prepare_sad}
\alias{prepare_sad}
\title{prepare a sad forecast for verification}
\usage{
prepare_sad(x, xmin = 0.1, log = TRUE, rsm = 0, Nx = NULL,
  Ny = NULL, boundaries = "pad")
}
\arguments{
\item{x}{a list of 2 or more 2D matrices with equal sizes and no missing or inifinite values, as required by \code{as.sadforecast}}

\item{xmin}{values smaller than \code{xmin} are set to zero}

\item{log}{logical, do you want to log-transfrom the data? (recommended for precipitation)}

\item{rsm}{number of pixels which are linearly smoothed at the edge}

\item{Nx}{size to which the data is extended in x-direction}

\item{Ny}{size to which the data is extended in y-direction}

\item{boundaries}{how to handle the boundary conditions, either "pad", "mirror" or "periodic"}
}
\value{
an object of class \code{sadforecast} which has been prepared in the desired way.
}
\description{
remove small values, apply log-transform, smooth borders, handle boundary conditions
}
\details{
the positions within the extended field where the original field resides are output as attributes "px", "py" of the result. The other input parameters are saved as attributes of the result as well.
}
\examples{
data( rrain )
ra <- list( rrain[2,4,,], rrain[3,9,,] )
ra <- prepare_sad( ra, rsm=0, Nx=256, boundaries="mirror", log=FALSE )
plot(ra)
}
