% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpecificExpression.R
\name{miVennData}
\alias{miVennData}
\title{Species specific expression analysis: miVennData}
\usage{
miVennData(
  P1_RPM,
  P2_RPM,
  F1_RPM,
  rpm_threshold = 1,
  output_file = "venn_list"
)
}
\arguments{
\item{P1_RPM}{A dataframe. The rpm data of miRNA from the P1 species. The first column must be the miRNA sequence. Others are listed as the rpm of miRNA, and each column denotes one biological replicate of the sample.}

\item{P2_RPM}{A dataframe. Similar with P1_RPM, the rpm data of miRNA from the P2 species.}

\item{F1_RPM}{A dataframe. Similar with P1_RPM, the rpm data of miRNA from the F1 species.}

\item{rpm_threshold}{A numeric. the average of rpm value among all the biological replicates. By default, the average of rpm more than or equal to 1 is retained.}

\item{output_file}{Specify the output file. "venn_list" is the default option, which outputs all the information of the Venn diagram. "all_common" is one of options, which outputs the miRNAs shared by parents and offspring. "P1_specific" is one of options, which outputs P1 specific expression miRNA. "P2_specific" is one of options, which outputs P2 specific expression miRNA. "F1_specific" is one of options, which outputs F1 specific expression miRNA.}
}
\value{
A dataframe. The output results is based on your selection (output_file).
}
\description{
miVennData: Extract the species-specific miRNAs and the shared miRNAs among parents and offspring.
}
\examples{
##Extract the species-specific miRNAs and the shared miRNAs among parents and offspring.
##output_file = "venn_list"
venn_list <- miVennData(P1_RPM = P1_miRNA_rpm,
                        P2_RPM = P2_miRNA_rpm,
                        F1_RPM = F1_miRNA_rpm,
                        rpm_threshold = 1,output_file = "venn_list")
##output_file = "P1_specific"
P1_specific <- miVennData(P1_RPM = P1_miRNA_rpm,
                          P2_RPM = P2_miRNA_rpm,
                          F1_RPM = F1_miRNA_rpm,
                          rpm_threshold = 1,output_file = "P1_specific")
##output_file = "P2_specific"
P2_specific <- miVennData(P1_RPM = P1_miRNA_rpm,
                          P2_RPM = P2_miRNA_rpm,
                          F1_RPM = F1_miRNA_rpm,
                          rpm_threshold = 1,output_file = "P2_specific")
##output_file = "F1_specific"
F1_specific <- miVennData(P1_RPM = P1_miRNA_rpm,
                          P2_RPM = P2_miRNA_rpm,
                          F1_RPM = F1_miRNA_rpm,
                          rpm_threshold = 1,output_file = "F1_specific")
##output_file = "all_common"
all_common <- miVennData(P1_RPM = P1_miRNA_rpm,
                         P2_RPM = P2_miRNA_rpm,
                         F1_RPM = F1_miRNA_rpm,
                         rpm_threshold = 1,output_file = "all_common")
}
