% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recursClust.R
\name{recursClust}
\alias{recursClust}
\title{Perform a multi level clustering}
\usage{
recursClust(
  dataFrame,
  levelMax = 2,
  clustFunction,
  similarity = TRUE,
  vois = 7,
  flagDiagZero = FALSE,
  biparted = FALSE,
  method = "default",
  tolerence = 0.99,
  threshold = 0.9,
  minPoint = 7,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{dataFrame}{The dataFrame.}

\item{levelMax}{The maximum depth level.}

\item{clustFunction}{the clustering function to apply on data.}

\item{similarity}{if True, will use the similarity matrix for the clustering function.}

\item{vois}{number of points that will be selected for the similarity computation.}

\item{flagDiagZero}{if True, Put zero on the similarity matrix W.}

\item{biparted}{if True, the function will not automatically choose the number of clusters to compute.}

\item{method}{The method that will be used. "default" to let the function choose the most suitable method. "PEV" for the Principal EigenValue method. "GAP" for the GAP method.}

\item{tolerence}{The tolerance allowed for the Principal EigenValue method.}

\item{threshold}{The threshold to select the dominant eigenvalue for the GAP method.}

\item{minPoint}{The minimum number of points required to compute a cluster.}

\item{verbose}{To output the verbose in the terminal.}

\item{...}{additional arguments for the clustering function.}
}
\value{
returns a list containing the following elements:
\itemize{
 \item{cluster: }{vector that contain the result of the last level}
 \item{allLevels: }{dataframe containing the clustering results of each levels}
 \item{nbLevels: }{the number of computed levels}
}
}
\description{
The function, for a given dataFrame, will separate the data using the input clustering method in several levels.
}
\examples{
### Example 1: 2 disks of the same size
n<-100 ; r1<-1
x<-(runif(n)-0.5)*2;
y<-(runif(n)-0.5)*2
keep1<-which((x*2+y*2)<(r1*2))
disk1<-data.frame(x+3*r1,y)[keep1,]
disk2 <-data.frame(x-3*r1,y)[keep1,]
sameTwoDisks <- rbind(disk1,disk2)
res <- recursClust(scale(sameTwoDisks),levelMax=3, clustFunction =ShiMalikSC,
                   similarity = TRUE, vois = 7, flagDiagZero = FALSE,
                   biparted = TRUE, verbose = TRUE)
plot(sameTwoDisks, col = as.factor(res$cluster))

### Example 2: Speed and Stopping Distances of Cars
res <- recursClust(scale(iris[,-5]),levelMax=4, clustFunction = spectralPAM,
                   similarity = TRUE, vois = 7, flagDiagZero = FALSE,
                   biparted = FALSE, method = "PEV", tolerence =  0.99,
                   threshold = 0.9, verbose = TRUE)
plot(iris, col = as.factor(res$cluster))
}
\author{
Emilie Poisson Caillault and Erwan Vincent
}
