% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReducedRankRegressions.R
\name{ReducedRankRegressions}
\alias{ReducedRankRegressions}
\title{Construct a poset of reduced rank regression models.}
\usage{
ReducedRankRegressions(numResponses, numCovariates, maxRank)
}
\arguments{
\item{numResponses}{the number of response variables.}

\item{numCovariates}{the number of covariates.}

\item{maxRank}{the largest rank model to be included in the collection.}
}
\value{
An object representing the collection.
}
\description{
Creates an object representing a collection of reduced rank regression
models. There is one model for each fixed rank from 1 to some specified
maximum. In particular each model is identified by a single number
specifiying the rank of the regression matrix in the model. Models are
naturally ordered by inclusion so that, for example, a model with 2
rank 2 comes before before a model with rank 3 or greater.
}

