% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelExtract.R
\name{modelExtract}
\alias{modelExtract}
\alias{modelExtract.function}
\alias{modelExtract.rxUi}
\alias{modelExtract.rxode2}
\alias{modelExtract.rxModelVars}
\alias{modelExtract.default}
\title{Extract model lines from a rxui model}
\usage{
modelExtract(
  x,
  ...,
  expression = FALSE,
  endpoint = FALSE,
  lines = FALSE,
  envir = parent.frame()
)

\method{modelExtract}{`function`}(
  x,
  ...,
  expression = FALSE,
  endpoint = FALSE,
  lines = FALSE,
  envir = parent.frame()
)

\method{modelExtract}{rxUi}(
  x,
  ...,
  expression = FALSE,
  endpoint = FALSE,
  lines = FALSE,
  envir = parent.frame()
)

\method{modelExtract}{rxode2}(
  x,
  ...,
  expression = FALSE,
  endpoint = FALSE,
  lines = FALSE,
  envir = parent.frame()
)

\method{modelExtract}{rxModelVars}(
  x,
  ...,
  expression = FALSE,
  endpoint = FALSE,
  lines = FALSE,
  envir = parent.frame()
)

\method{modelExtract}{default}(
  x,
  ...,
  expression = FALSE,
  endpoint = FALSE,
  lines = FALSE,
  envir = parent.frame()
)
}
\arguments{
\item{x}{model to extract lines from}

\item{...}{variables to extract. When it is missing, it will
extract the entire model (conditioned on the endpoint option
below)}

\item{expression}{return expressions (if \code{TRUE}) or strings (if
\code{FALSE})}

\item{endpoint}{include endpoint.  This can be:
\itemize{
\item \code{NA}    -- Missing means include both the endpoint and non-endpoint lines
\item \code{TRUE}  -- Only include endpoint lines
\item \code{FALSE} -- Only include non-endpoint lines
}}

\item{lines}{is a boolean.  When \code{TRUE} this will add the lines as
an attribute to the output value ie \code{attr(, "lines")}}

\item{envir}{Environment for evaluating variables}
}
\value{
expressions or strings of extracted lines. Note if there is
a duplicated lhs expression in the line, it will return both
lines
}
\description{
Extract model lines from a rxui model
}
\examples{

one.compartment <- function() {
  ini({
    tka <- 0.45 # Log Ka
    tcl <- 1 # Log Cl
    tv <- 3.45    # Log V
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
  })
  model({
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v  <- exp(tv + eta.v)
    d/dt(depot)  <- -ka * depot
    d/dt(center) <-  ka * depot - cl / v * center
    cp <- center / v
    cp ~ add(add.sd)
  })
 }

 f <- one.compartment()

 modelExtract(f, cp)

 modelExtract(one.compartment, d/dt(depot))

 # from variable
 var <- "d/dt(depot)"

 modelExtract(one.compartment, var)

 modelExtract(f, endpoint=NA, lines=TRUE, expression=TRUE)

}
\author{
Matthew L. Fidler
}
