% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoftThresh.R
\name{SoftThresh}
\alias{SoftThresh}
\title{Apply Soft Threshold}
\usage{
SoftThresh(y, t)
}
\arguments{
\item{y}{Noisy Data.}

\item{t}{Threshold.}
}
\value{
\code{x} filtered result (y 1_{|y|>t}).
}
\description{
Apply Soft Threshold
}
\examples{
f <- MakeSignal('HeaviSine', 2^3)
qmf <- MakeONFilter('Daubechies', 10)
L <- 0
wc <- FWT_PO(f, L, qmf)
thr <- 2
wct <- SoftThresh(wc, thr)
fsoft <- IWT_PO(wct, L, qmf)
}
\seealso{
\code{\link{HardThresh}}
}
