% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IWT_PO.R
\name{IWT_PO}
\alias{IWT_PO}
\title{Inverse Wavelet Transform (periodized, orthogonal)}
\usage{
IWT_PO(wc, L, qmf)
}
\arguments{
\item{wc}{1-d wavelet transform: length(wc) = 2^J.}

\item{L}{Coarsest scale (2^(-L) = scale of V_0); L << J.}

\item{qmf}{quadrature mirror filter (orthonormal).}
}
\value{
\code{x} 1-d signal reconstructed from wc.
}
\description{
Suppose \code{wc <- FWT_PO(x,L,qmf)} where \code{qmf} is an orthonormal quad.
mirror filter, e.g. one made by \code{\link{MakeONFilter}}.
Then x can be reconstructed by \code{x <- IWT_PO(wc,L,qmf)}.
}
\examples{
x <- MakeSignal('Ramp', 8)
L <- 0
qmf <- MakeONFilter('Haar')
wc <- FWT_PO(x, L, qmf)
xr <- IWT_PO(wc,L,qmf)
}
\seealso{
\code{\link{FWT_PO}}, \code{\link{MakeONFilter}}.
}
