% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revgeocoding.R
\name{rtry_revgeocoding}
\alias{rtry_revgeocoding}
\title{Perform reverse geocoding}
\usage{
rtry_revgeocoding(lat_lon, email)
}
\arguments{
\item{lat_lon}{A data frame containing latitude and longitude in WGS84 projection.}

\item{email}{String of an email address.}
}
\value{
A data frame that contains address.
}
\description{
This function uses \href{https://wiki.openstreetmap.org/wiki/Nominatim}{Nominatim},
a search engine for OpenStreetMap data, to perform reverse geocoding,
i.e. converting coordinates (latitudes, longitudes) into an address.
The data provided by OSM is free to use for any purpose, including commercial use,
and is governed by the distribution license \href{https://wiki.osmfoundation.org/wiki/Licence}{ODbL}.
}
\examples{
\dontrun{
# Convert the coordinates of MPI-BGC (50.9101, 11.56674) into an address
# Note: Please change to your own email address when executing this function
rtry_revgeocoding(data.frame(50.9101, 11.56674),
  email = "john.doe@example.com")

# Expected message:
#               full_address town city country country_code
# 1 Jena, Thuringia, Germany   NA Jena Germany           de
}

# Learn to perform reverse geocoding to a list of coordinates via the vignette
# (Workflow for geocoding using rtry): vignette("rtry-workflow-geocoding").
}
\seealso{
\code{\link{rtry_geocoding}}
}
