% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{set_editor}
\alias{set_editor}
\title{Set editor}
\usage{
set_editor(
  widget,
  column,
  editor = c("input", "textarea", "number", "range", "tickCross", "star", "progress",
    "date", "time", "datetime", "list"),
  validator = NULL,
  ...
)
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{column}{The name of the column the formatter is applied to.}

\item{editor}{(character): The editor type.}

\item{validator}{(character vector): One or more validators to validate user input.}

\item{...}{Optional editor parameters depending on the selected editor.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set editor
}
\examples{
setup <- tabulator_options(edit_trigger_event = "click")

tabulator(iris[, c(2, 5)], setup) |>
  set_editor(
    column = "Species",
    editor = "list",
    values_lookup = "active",
    clearable = TRUE,
    autocomplete = TRUE
  ) |>
  set_editor(
    column = "Sepal_Width",
    editor = "number",
    min = 0,
    max = 10,
    step = 0.1,
    validator = c("min:0", "max:10")
  )
}
\seealso{
\itemize{
\item \url{https://tabulator.info/docs/6.2/edit} for available editors
\item \url{https://tabulator.info/docs/6.2/validate} for available validators
}
}
