% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_model_api.R
\name{get_example_query}
\alias{get_example_query}
\title{Get Example Query for Model}
\usage{
get_example_query(model_id, api_base_url = API_BASE_URL)
}
\arguments{
\item{model_id}{Character string specifying the model ID (e.g., "gem-1-bulk", "gem-1-sc").}

\item{api_base_url}{The base URL for the API server. Default is API_BASE_URL.}
}
\value{
A list representing a valid query structure for the specified model.
}
\description{
Retrieves an example query structure for a specific model.
This provides a template that can be modified for your specific needs.
}
\examples{
\dontrun{
# Get example query for bulk RNA-seq model
query <- get_example_query(model_id = "gem-1-bulk")

# Get example query for single-cell model
query_sc <- get_example_query(model_id = "gem-1-sc")

# Modify the query structure
query$inputs[[1]]$num_samples <- 10
}
}
