% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condaFilepath.R
\name{condaFilepath}
\alias{condaFilepath}
\alias{condaFilepath,Session-method}
\alias{condaFilepath,missingOrNULLOrChar-method}
\alias{condaFilepath<-}
\alias{condaFilepath<-,character-method}
\alias{condaFilepath<-,Session-method}
\title{Path to Conda installation folder}
\usage{
condaFilepath(session)

\S4method{condaFilepath}{Session}(session)

\S4method{condaFilepath}{missingOrNULLOrChar}(session)

condaFilepath(session) <- value

\S4method{condaFilepath}{character}(session) <- value

\S4method{condaFilepath}{Session}(session) <- value
}
\arguments{
\item{session}{\code{\link{Session-class}} object or character (i.e. filepath to a
session). If \code{NULL}, \code{session()} will be used}

\item{value}{character. If empty, then returns the current Conda installation
path}
}
\value{
A character: the currently set filepath of the Conda installation folder.
}
\description{
Gets or sets the path to the Conda installation folder. Can be used to direct
SyncroSim to a custom Conda installation.
}
\examples{
\dontrun{
# Set up a SyncroSim Session
mySession <- session()

# Retrieve Conda installation path for the SyncroSim Session
condaFilepath(mySession)

# Set the Conda installation path for the SyncroSim Session
condaFilepath(mySession) <- "C:/miniconda3"
}

}
