% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartData.R
\name{chartData}
\alias{chartData}
\alias{chartData,Chart-method}
\title{Sets the \code{\link{Chart-class}} type and axes}
\usage{
chartData(
  chart,
  type = "Line",
  addX = NULL,
  addY = NULL,
  removeX = NULL,
  removeY = NULL,
  timesteps = NULL,
  iterationType = "Mean",
  iteration = 1
)

\S4method{chartData}{Chart}(
  chart,
  type = "Line",
  addX = NULL,
  addY = NULL,
  removeX = NULL,
  removeY = NULL,
  timesteps = NULL,
  iterationType = "Mean",
  iteration = 1
)
}
\arguments{
\item{chart}{\code{\link{Chart-class}} object}

\item{type}{character. Chart type. Can be "Line" (Default) or "Column".}

\item{addX}{character or character vector. X variable(s) to add to the chart.
If \code{NULL} (Default), does not add any X variables. If no X variables
specified in chart, then will default to plotting timesteps on the X axis.}

\item{addY}{character or character vector. Y variable(s) to add to the chart.
If \code{NULL} (Default), does not add any Y variables.}

\item{removeX}{character or character vector. X variable(s) to remove from
plot. If \code{NULL} (Default), then does not remove any X variables.}

\item{removeY}{character or character vector. Y variable(s) to remove from
plot. If \code{NULL} (Default), then does not remove any Y variables.}

\item{timesteps}{integer vector. The range of timesteps to plot against
If \code{NULL}, then uses SyncroSim defaults.}

\item{iterationType}{character. How to display multiple iterations in the
chart. Can be "Mean" (Default), "Single", or "All".}

\item{iteration}{integer. If the \code{iterationType} is set to "Single", this argument
determines which iteration to display. Default is 1.}
}
\value{
A \code{Chart} object representing a SyncroSim chart
}
\description{
Sets the \code{\link{Chart-class}} type and adds the variables to plot
in the line chart.
}
\examples{
\dontrun{
# Create a chart object
myChart <- chart(myProject, chart = "New Chart")

# Set the chart type and data
myChart <- chartData(myChart, y = c("variable1", "variable2"),
timesteps = c(0,10), iterationType = "single", iteration = 1)

}

}
