% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/villeneuve.R
\name{modify_graph_vd}
\alias{modify_graph_vd}
\title{Villeneuve and Desaulniers (2005) Algorithm}
\usage{
modify_graph_vd(g, f, cores = 1L)
}
\arguments{
\item{g}{The digraph to be transformed, written as a data frame where each row represents
a directed arc. The first two columns must be named \code{from} and \code{to}, and can be
of any data type. No cells can be \code{NULL} or \code{NA}.}

\item{f}{The set of forbidden paths, written as a data frame. Each row represents a path as
a sequence of nodes. Each row may be of different size, filling the empty cells with
\code{NA}. All nodes involved must be part of \code{g}, and no forbidden path can be of
size 2. This is because the latter is thought as an arc that should not exist in the first
place. Also, no forbidden path can be sub-path (or contain a sub-path) of another forbidden
path. The columns names are not relevant.}

\item{cores}{This algorithm can be run using R's parallel processing functions. This variable
represents the number of processing cores you want to assign for the transformation. The
default value is one single core. It is suggested to not assign all of your available cores
to the function.}
}
\value{
A new graph, generated following Villeneuve's prodcedure, in which no path
   includes one of the forbidden subpaths. The graph is returned in a data frame format,
   where each row represents a directed arc. However, regardless of the data type of the
   original graph, nodes on the new graph are of type character. The new nodes names are
   generated by incrementally concatenating the nodes on a forbidden path, but split by a
   pipe character (\code{|}). The new graph includes all of the additional attributes
   that the original graph had.
}
\description{
It is an implementation of Villeneuve and Desaulniers' algorithm to transform
   a digraph and a known set of forbidden paths, into a new graph that does not allow any
   forbidden path as part of its solutions. This algorithm should only be used when there
   is certainty that no forbidden path is a sub-path (or contains a sub-path) of another
   forbidden path.
}
\examples{
# Obtain a graph and its forbidden subpaths
graph <- data.frame(from = c("s", "s", "s", "u", "u", "w", "w", "x", "x", "v", "v",
                             "y", "y"), 
                    to = c("u", "w", "x", "w", "v", "v", "y", "w", "y", "y", "t", "t", "u"), 
                    cost = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L), 
                    stringsAsFactors = FALSE)
                     
fpaths <- data.frame(V1 = c("s", "u"), V2 = c("u", "v"), V3 = c("v", "y"), V4 = c("t", "u"), 
                     stringsAsFactors = FALSE)
                      
# Show the values
graph
fpaths                      

# Call the function and store the result
modify_graph_vd(graph, fpaths)

}
\seealso{
\url{https://doi.org/10.1016/j.ejor.2004.01.032}

Other Graph Transformation: \code{\link{modify_graph_hsu}}
}
\concept{Graph Transformation}
