% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseConstraints.R
\name{sparseConstraints}
\alias{sparseConstraints}
\alias{sparseConstraints.editmatrix}
\alias{sparseConstraints.matrix}
\alias{sparseConstraints.data.frame}
\alias{print.sparseConstraints}
\title{DEPRECATED Generate sparse set of constraints.}
\usage{
sparseConstraints(x, ...)

\method{sparseConstraints}{editmatrix}(x, tol = 1e-08, ...)

\method{sparseConstraints}{matrix}(x, b, neq = length(b), tol = 1e-08, ...)

\method{sparseConstraints}{data.frame}(
  x,
  b,
  neq = length(b),
  base = min(x[, 2]),
  sorted = FALSE,
  ...
)

\method{print}{sparseConstraints}(x, range = 1L:10L, ...)
}
\arguments{
\item{x}{R object to be translated to sparseConstraints format.}

\item{...}{options to be passed to other methods}

\item{tol}{Tolerance for testing where coefficients are zero}

\item{b}{Constant vector}

\item{neq}{The first \code{new} equations are interpreted as equality constraints, the rest as '<='}

\item{base}{are the indices in \code{x[,1:2]} base 0 or base 1?}

\item{sorted}{is \code{x} sorted by the  first column?}

\item{range}{integer vector stating which constraints to print}
}
\value{
Object of class \code{sparseConstraints} (see details).
}
\description{
This function is deprecated. Please use function \code{\link[lintools]{sparse_constraints}} from package
\code{\link[lintools]{lintools}} instead.
}
\section{Details}{


The \code{sparseConstraints} objects holds the system \eqn{\boldsymbol{Ax}\leq \boldsymbol{b}}
in column sparse format, outside of \code{R}'s memory. In \code{R}, it is a \emph{reference object}.
In particular, it is meaningless to
\itemize{
   \item{Copy the object. You only will only generate a pointer to physically the same object.}
   \item{Save the object. The physical object is destroyed when \code{R} closes, or when \code{R}'s
     garbage collector cleans up a removed \code{sparseConstraints} object.}
}
}

\keyword{internal}
