% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa_counts.R
\name{taxa_counts}
\alias{taxa_counts}
\title{Quantitation of microbes}
\usage{
taxa_counts(umi_list, samples = NULL)
}
\arguments{
\item{umi_list}{A list of polars \link[polars:DataFrame_class]{DataFrame} for UMI
data returned by \link{prep_dataset}.}

\item{samples}{A character of sample identifier for each element in
\code{umi_list}.}
}
\value{
A polars \link[polars:DataFrame_class]{DataFrame}.
}
\description{
After identifying true taxa, reads assigned to those taxa are
extracted and then undergo a series of filters. The cell barcode and UMI are
used to demultiplex the reads and create a barcode x taxa counts matrix. The
full taxonomic classification of all resulting barcodes and the number of
counts assigned to each clade are tabulated.
}
\examples{
\dontrun{
# `umi_list` should be the output of all samples from `prep_dataset()`, and 
# filtered by `slsd()` and `blsd()`
taxa_counts(umi_list, basename(names(umi_list)))
}
}
\seealso{
\url{https://github.com/sjdlabgroup/SAHMI}
}
