% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrr.R
\name{scores}
\alias{scores}
\title{Compute Latent Variable Scores}
\usage{
scores(x, y, type = "pca", rank = "full", k = 0)
}
\arguments{
\item{x}{data frame or matrix of predictor variables}

\item{y}{data frame or matrix of response variables}

\item{type}{type of reduced-rank regression model to fit. \code{type = "identity"}, the default, uses \eqn{\mathbf{\Gamma} = \mathbf{I}} to fit a reduced-rank regression. \code{type = "pca"} fits a principal component analysis model as a special case of reduced-rank regression. \code{type = "cva"} fits a canonical variate analysis model as a special case of reduced-rank regression. \code{type = "lda"} fits a linear discriminant analysis model as a special case of reduced-rank regression.}

\item{rank}{rank of coefficient matrix.}

\item{k}{small constant added to diagonal of covariance matrices to make inversion easier.}
}
\description{
Compute Latent Variable Scores
}
\examples{
data(pendigits)
digits_features <- pendigits[, -35:-36]
scores(digits_features, digits_features, type = "pca", rank = 3)

library(dplyr)
data(COMBO17)
galaxy <- as_data_frame(COMBO17)
galaxy <- select(galaxy, -starts_with("e."), -Nr, -UFS:-IFD)
galaxy <- na.omit(galaxy)
galaxy_x <- select(galaxy, -Rmag:-chi2red)
galaxy_y <- select(galaxy, Rmag:chi2red)
scores(galaxy_x, galaxy_y, type = "cva", rank = 4)

data(iris)
iris_x <- iris[,1:4]
iris_y <- iris[5]
scores(iris_x, iris_y, type = "lda")

}
\references{
Izenman, A.J. (2008) \emph{Modern Multivariate Statistical Techniques}. Springer.
}

