% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipla-function.R
\name{ipla}
\alias{ipla}
\title{Identify placental aging}
\usage{
ipla(
  aging,
  ga,
  phenotype,
  case = "Case",
  control = "Control",
  method = NULL,
  from = NULL,
  to = NULL
)
}
\arguments{
\item{aging}{A data frame of residual DNA-methylation-based GA. This data
frame must be the output of \code{\link{plec}} function with argument
\code{type="residual"}. The rows must be named according to the sample IDs.}

\item{ga}{A data frame of GA. There is only one column, i.e., \code{GA}, as shown
in \code{ga}. Use \code{data(ga)} to load this data frame. The rows must be named
according to the sample IDs.}

\item{phenotype}{A data frame of phenotype (optional. There is only one
column, i.e., \code{phenotype}, as shown in \code{phenotype}. Use
\code{data(phenotype)} to load this data frame. The rows must be named
according to the sample IDs.}

\item{case}{A character of of case name in \code{phenotype} (default="Case").}

\item{control}{A character of of case name  in \code{phenotype}
(default="Control").}

\item{method}{A character of of the method of statistical test (optional),
i.e., "Mann-Whitney U" or "Permutation".}

\item{from}{An integer from 5 to 44 indicating minimum GA (weeks) to be
included in the statistical test. If it is undefined, the minimum GA in
either case or control is applied.}

\item{to}{An integer from 5 to 44 indicating maximum GA (weeks) to be
included in the statistical test. If it is undefined, the maximum GA in
either case or control is applied.}
}
\value{
An ggplot object consisting the aging plot without or with
statistical test results.
}
\description{
This function identifies placental aging based on the case-control aging
difference. Placental aging is defined as the residual DNA-methylation-based
(DNAm) gestational ages (GA). Only GA from 5 to 44 weeks' gestation are
shown in the placental aging plot.
}
\examples{

# Prepare data
data(aging)
data(ga)
data(phenotype)

# Identify placental aging
set.seed(1)
ipla(aging, ga, phenotype)

## Conduct statistical test
set.seed(1)
ipla(aging, ga, phenotype, method = "Mann-Whitney U")

## Conduct statistical test for a specific range of GA
set.seed(1)
ipla(aging, ga, phenotype, method = "Mann-Whitney U", from = 5, to = 20)
}
\keyword{gestational-age}
\keyword{placental-aging}
\keyword{placental-epigenetic-clock}
