% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmiq_norm_450k-function.R
\name{bmiq_norm_450k}
\alias{bmiq_norm_450k}
\title{Normalize DNA methylation values}
\usage{
bmiq_norm_450k(beta, cores = 1, verbose = FALSE)
}
\arguments{
\item{beta}{A data frame of beta values where each column represents a
sample and each row represent a probe. The rows must be named according to
the probe IDs. They include all the required probes. Run
\code{data(probe_info_450k)} and find the required probes in
\code{prob_info_450k$probeID}. Meanwhile, the columns must be named according to
the sample IDs.}

\item{cores}{An integer indicating the number of threads.}

\item{verbose}{A logical scalar indicating whether to show a progress bar.}
}
\value{
A data frame of normalized beta values.
}
\description{
This function normalize DNA methylation values from 450k probes. The probes
are filtered and ordered the same way to the input when we developed our
placental epigenetic clock.
}
\examples{

\donttest{
  beta_values_case <- download_beta_values_case()
  norm_beta_values_case <- bmiq_norm_450k(beta_values_case)
}
}
\keyword{450k}
\keyword{bmiq}
\keyword{normalization}
