% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotatogram.R
\name{rotatogram}
\alias{rotatogram}
\title{Rotatogram}
\usage{
rotatogram(
  x1,
  x2,
  x1.label = "X1",
  x2.label = "X2",
  suppress.plot = FALSE,
  return.values = FALSE
)
}
\arguments{
\item{x1}{(required) A vector containing the data for the x1 variable}

\item{x2}{(required) A vector containing the data for the x2 variable}

\item{x1.label}{(optional) Changes the x1 axis label to the specified name}

\item{x2.label}{(optional) Changes the x2 axis label to the specified name}

\item{suppress.plot}{(optional) Suppresses the plot output}

\item{return.values}{(optional) Exports the stored data for later access (e.g. slope and intercept calculated)}
}
\value{
description The resulting object contains the resulting intercept ($intercept), slope/beta ($beta), the slope in degrees ($slope.degrees)
}
\description{
A rotatogram is a method of displaying an association which is axis non-dominant. This is achieved in two ways: First, the method of estimating the slope and intercept uses the least-products method rather than more typical least squared error for the "dependent" variable. The least products method has no "dependent" variable and is scale independent. Second, the plot is rotated such that the resulting regression line is vertical, reducing the suggestion that the vertical axis is the dominant one. The slope can be read relative to either axis equally.
}
\examples{
# Output a rotatogram using the iris dataset
rotatogram(iris$Sepal.Length,iris$Petal.Length,x1.label="Sepal length",x2.label="Petal length")

}
\keyword{association}
