% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temp_overlap_plot.R
\name{temp_overlap_plot}
\alias{temp_overlap_plot}
\title{Plot null-model results for temporal niche overlap}
\usage{
temp_overlap_plot(results)
}
\arguments{
\item{results}{A list object returned by \code{\link[=get_null_model]{get_null_model()}}, containing
\code{null_niche_overlap} (data frame of simulated overlaps) and
\code{observed_niche_overlap} (numeric observed value).}
}
\value{
A \code{ggplot2} object displaying the null distribution of overlap values
with the observed overlap marked.
}
\description{
Creates a histogram of simulated mean niche overlap values from a null model
(see \code{\link[=get_null_model]{get_null_model()}}) and overlays a dashed vertical line indicating the
observed mean overlap.
}
\examples{
mod <- get_null_model(ex1, method = "pianka", nsim = 100)
temp_overlap_plot(mod)

}
\seealso{
\code{\link[=get_null_model]{get_null_model()}}, \code{\link[=temp_overlap]{temp_overlap()}}
}
