% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_spread.R
\name{call.spread}
\alias{call.spread}
\title{Bull/Bear Call Spread Strategy Function}
\usage{
call.spread(k1, k2, c1, c2, llimit = 20, ulimit = 20)
}
\arguments{
\item{k1}{Excercise Price of Long call Option}

\item{k2}{Excercise Price of Short Call Option}

\item{c1}{Premium of Long call Option}

\item{c2}{Premium of Short Call Option}

\item{llimit}{Lower limit of stock price at Expiration., Default: 20}

\item{ulimit}{Upper Limit of Stock Price at Expiration, Default: 20}
}
\value{
OUTPUT_DESCRIPTION Returns the profit/loss generated from the strategy along with the profit/loss of individual contract and an interactive graph for the same.
}
\description{
This function can be used to develop a Bull/Bear Call Strategy.
}
\details{
Bull Call Spread uses two call options to create a range consisting of a lower strike price and an upper strike price.bear call spread is achieved by purchasing call options at a specific strike price while also selling the same number of calls with the same expiration date, but at a lower strike price.
}
\examples{
call.spread(1.2, 3.2, 100, 105)
}
