% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_greek.R
\name{call.greek}
\alias{call.greek}
\title{Specified Call Option Greek}
\usage{
call.greek(
  greek = c("delta", "gamma", "theta", "vega", "rho"),
  s,
  k,
  t,
  sd,
  r,
  d = 0
)
}
\arguments{
\item{greek}{Character String of the greek to be calculated}

\item{s}{Spot Price of Underlying Asset}

\item{k}{Exercise Price of Contract}

\item{t}{Time to Expiration}

\item{sd}{Volatality}

\item{r}{Risk free rate of return}

\item{d}{Divident Yield (use cont.rate()), Default: 0}
}
\value{
Output gives the Specified Greek of a Option Contract.
}
\description{
Calculate the Specified Option Greek of a Contract
}
\details{
Delta represents the rate of change between the option's price and a $1 change in the underlying asset's price. Theta represents the rate of change between the option price and time, or time sensitivity - sometimes known as an option's time decay. Gamma represents the rate of change between an option's delta and the underlying asset's price. Vega represents the rate of change between an option's value and the underlying asset's implied volatility. Rho represents the rate of change between an option's value and a 1\% change in the interest rate.
}
\examples{
call.greek('delta', 100, 105, 0.25, 0.35, 0.0488)
}
