% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{comparisons}
\alias{comparisons}
\alias{\%==\%}
\alias{\%===\%}
\alias{\%>=\%}
\alias{\%<=\%}
\alias{\%><\%}
\alias{\%>=<\%}
\title{Enhanced comparisons}
\usage{
x \%==\% y

x \%===\% y

x \%>=\% y

x \%<=\% y

x \%><\% y

x \%>=<\% y
}
\arguments{
\item{x}{a vector}

\item{y}{a vector}
}
\description{
These operators introduce improved NA handling, reliable floating point tests,
and intervals. Specifically:

Equality that handles missing values

Floating point equality, an important bit of functionality missing in base R (\code{\%~=\%})

Strict (value and type) equality, for those familiar with Javascript \code{===}

Greater/less than or equal to with missing value equality

Greater/less than or equal to with floating point and missing equality

Between (ends excluded)

Between (ends included)
}
\examples{
 ## Greater/Less than | Equal

 c(1, NA, 3, 4)  ==  c(1, NA, 4, 3)
 #  TRUE    NA  FALSE FALSE

 c(1, NA, 3, 4) \%==\% c(1, NA, 4, 3)
 #  TRUE  TRUE  FALSE FALSE

 c(1, NA, 3, 4) \%>=\% c(1, NA, 4, 3)
 #  TRUE  TRUE FALSE  TRUE

 c(1, NA, 3, 4) \%<=\% c(1, NA, 4, 3)
 #  TRUE  TRUE TRUE  FALSE


 # Strict equality - a la javascript's ===
 # Only tru if the class and value of x and y are the same
x <- int(2)
y <- 2
x == y         # TRUE
x \%===\% y      # FALSE
x \%===\% int(y) # TRUE


 # NOTE parentheses surrounding expression before this operator are necessary
 # Without parentheses it would be interpreted as .1 + .1 + (.1 \%~=\% .3)


 #### Between ####

 # ends excluded

 2 \%><\% c(1, 3)
 # TRUE

 3 \%><\% c(1, 3)
 # FALSE

 # ends included

 2 \%>=<\% c(1, 3)
 # TRUE

 3 \%>=<\% c(1, 3)
 # TRUE

}
\seealso{
Other comparisons: 
\code{\link{floating_point_comparisons}}
}
\author{
Ben Wiseman, \email{benjamin.wiseman@kornferry.com}
}
\concept{comparisons}
