% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_state_transition_dot.R
\name{get_state_transition_dot}
\alias{get_state_transition_dot}
\title{Get the Dot code for a state transition graph}
\usage{
get_state_transition_dot(
  x,
  labelFun = base::round,
  labelFunArgs = list(digits = 2)
)
}
\arguments{
\item{x}{A state transition table as produced by a call
to \code{\link[=get_state_transition_table]{get_state_transition_table()}}.}

\item{labelFun}{A function to apply to the edge labels in preprocessing.}

\item{labelFunArgs}{Arguments to specify to \code{labelFun} in addition to the
first argument (the edge weight, a number).}
}
\value{
The Dot code for a state transition graph.
}
\description{
Get the Dot code for a state transition graph
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "state-example-1.rock");

### Parse single example source
parsedExample <- rock::parse_source(exampleFile);

### Show the state transition probabilities
exampleTable <- rock::get_state_transition_table(
  parsedExample
);

exampleStateDf <- rock::get_state_transition_df(
  exampleTable
);

exampleDotCode <- rock::get_state_transition_dot(
  exampleStateDf
);

DiagrammeR::grViz(exampleDotCode);

}
